/*****************************************************************************
 *   pmu.h:  Header file for NXP LPC17xx Family Microprocessors
 *
 *   Copyright(C) 2008, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2008.09.01  ver 1.00    Preliminary version, first Release
 *
******************************************************************************/
#ifndef __PMU_H 
#define __PMU_H

#define MCU_SLEEP			0
#define MCU_DEEP_SLEEP		1
#define MCU_POWERDOWN		0
#define MCU_DEEP_POWERDOWN	1

/* See Cortex M3 UM for more detail, System Low Power */
#define NVIC_LP_SEVONPEND            (0x10)
#define NVIC_LP_SLEEPDEEP            (0x04)
#define NVIC_LP_SLEEPONEXIT          (0x02)

void MinimumSystemInit( void );
void EINT0_IRQHandler( void );
void PMU_Init( void );
int PMU_Sleep( uint32_t SleepMode );
int PMU_PowerDown( uint32_t PowerdownMode );

#endif /* end __PMU_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
